unit Semaphr;

interface

uses
  SysUtils, 
  WinTypes, 
  WinProcs, 
  Messages, 
  Classes, 
  Graphics, 
  Controls,
  Forms, 
  Dialogs, 
  NWServer, 
  Nwtools, 
  ExtCtrls, 
  StdCtrls, 
  Buttons, 
  Spin;

type
  TwinSemaphore = class(TForm)
    Label1: TLabel;
    counter: TEdit;
    Timer1: TTimer;
    NWTools1: TNWTools;
    NWServer1: TNWServer;
    Label2: TLabel;
    Label3: TLabel;
    semaValue: TEdit;
    Label4: TLabel;
    valueSpinner: TSpinButton;
    BitBtn1: TBitBtn;
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure valueSpinnerDownClick(Sender: TObject);
    procedure valueSpinnerUpClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winSemaphore: TwinSemaphore;

implementation

{$R *.DFM}

var
  semaphoreHandle : TNWSemaHandle ;


procedure TwinSemaphore.FormShow(Sender: TObject);
  begin
    semaphoreHandle := createSemaphore(0,'NWLIB',10) ;  {ie, a 10-station semaphore} 
    if (semaphoreHandle = 0) then    
      begin                   
        alertBox('Error Creating/Accessing Semaphore Handle;;' +
                 'Maximum Semaphore Stations May be Reached');
        valueSpinner.enabled := false ;
      end
    else
      timer1Timer(sender) ;
  end;

procedure TwinSemaphore.FormClose(Sender: TObject;
                                  var Action: TCloseAction);
  begin
    { always clean up your mess! }
    freeSemaphore(0,semaphoreHandle);
    action := caFree ;
  end;

procedure TwinSemaphore.Timer1Timer(Sender: TObject);
  var
    value : word ;
  begin
    timer1.enabled := false ;
    value          := 0 ;
    counter.text := intToStr(querySemaphore(0,semaphoreHandle,value)) ;
    semaValue.text := intToStr(value) ;
    timer1.enabled := true ;
  end;

procedure TwinSemaphore.valueSpinnerDownClick(Sender: TObject);
  { the Semaphore Value is a counter within the semaphore that you
    can use any way you like, independently of maxInstances }
  begin
    if not decSemaValue(0,semaphoreHandle,1) then
      okbox('We''re Plum Out of Semaphore Values!') ;
    timer1Timer(sender) ;
  end;

procedure TwinSemaphore.valueSpinnerUpClick(Sender: TObject);
  begin
    if not incSemaValue(0,semaphoreHandle,5) then
      okbox('Ahg...She Won''t Take Any More, Captain!') ;
    timer1Timer(sender) ;
  end;

end.
 